[R1]debian@debian:~$ cat .bashrc 
# ~/.bashrc: executed by bash(1) for non-login shells.
# see /usr/share/doc/bash/examples/startup-files (in the package bash-doc)
# for examples

# If not running interactively, don't do anything
case $- in
    *i*) ;;
      *) return;;
esac

# don't put duplicate lines or lines starting with space in the history.
# See bash(1) for more options
HISTCONTROL=ignoreboth

# append to the history file, don't overwrite it
shopt -s histappend

# for setting history length see HISTSIZE and HISTFILESIZE in bash(1)
HISTSIZE=1000
HISTFILESIZE=2000

# check the window size after each command and, if necessary,
# update the values of LINES and COLUMNS.
shopt -s checkwinsize

# If set, the pattern "**" used in a pathname expansion context will
# match all files and zero or more directories and subdirectories.
#shopt -s globstar

# make less more friendly for non-text input files, see lesspipe(1)
#[ -x /usr/bin/lesspipe ] && eval "$(SHELL=/bin/sh lesspipe)"

PATH+=":$HOME/tools/"
eval `tset -s rxvt-unicode-256color`
color_prompt=yes
force_color_prompt=yes
# set variable identifying the chroot you work in (used in the prompt below)
if [ -z "${debian_chroot:-}" ] && [ -r /etc/debian_chroot ]; then
    debian_chroot=$(cat /etc/debian_chroot)
fi

# set a fancy prompt (non-color, unless we know we "want" color)
case "$TERM" in
    xterm-color|*-256color) color_prompt=yes;;
esac

# uncomment for a colored prompt, if the terminal has the capability; turned
# off by default to not distract the user: the focus in a terminal window
# should be on the output of commands, not on the prompt
#force_color_prompt=yes

if [ -n "$force_color_prompt" ]; then
    if [ -x /usr/bin/tput ] && tput setaf 1 >&/dev/null; then
	# We have color support; assume it's compliant with Ecma-48
	# (ISO/IEC-6429). (Lack of such support is extremely rare, and such
	# a case would tend to support setf rather than setaf.)
	color_prompt=yes
    else
	color_prompt=
    fi
fi

if [ "$color_prompt" = yes ]; then
    PS1='[C2]${debian_chroot:+($debian_chroot)}\[\033[01;32m\]\u@\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\]\$ '
else
    PS1='${debian_chroot:+($debian_chroot)}\u@\h:\w\$ '
fi
unset color_prompt force_color_prompt

# If this is an xterm set the title to user@host:dir
case "$TERM" in
xterm*|rxvt*)
    PS1="\[\e]0;${debian_chroot:+($debian_chroot)}[C2]\u@\h: \w\a\]$PS1"
    ;;
*)
    ;;
esac

# enable color support of ls and also add handy aliases
if [ -x /usr/bin/dircolors ]; then
    test -r ~/.dircolors && eval "$(dircolors -b ~/.dircolors)" || eval "$(dircolors -b)"
    alias ls='ls --color=auto'
    #alias dir='dir --color=auto'
    #alias vdir='vdir --color=auto'

    #alias grep='grep --color=auto'
    #alias fgrep='fgrep --color=auto'
    #alias egrep='egrep --color=auto'
fi

# colored GCC warnings and errors
#export GCC_COLORS='error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01'

# some more ls aliases
#alias ll='ls -l'
#alias la='ls -A'
#alias l='ls -CF'

# Alias definitions.
# You may want to put all your additions into a separate file like
# ~/.bash_aliases, instead of adding them here directly.
# See /usr/share/doc/bash-doc/examples in the bash-doc package.

if [ -f ~/.bash_aliases ]; then
    . ~/.bash_aliases
fi

# enable programmable completion features (you don't need to enable
# this, if it's already enabled in /etc/bash.bashrc and /etc/profile
# sources /etc/bash.bashrc).
if ! shopt -oq posix; then
  if [ -f /usr/share/bash-completion/bash_completion ]; then
    . /usr/share/bash-completion/bash_completion
  elif [ -f /etc/bash_completion ]; then
    . /etc/bash_completion
  fi
fi


alias acs="apt-cache search --full"
alias ac="apt-cache search "
alias ai="sudo apt install "
alias rr="sudo reboot now"
alias vrc="vi ~/.bashrc"
alias vp="vi ~/.profile"
alias ua="source ~/.bashrc"

function _fix_ssh(){
sudo mkdir /run/sshd
sudo /usr/sbin/sshd
ps aux | grep ssh
}
function __s(){
~/q.sh ok
sudo ip a a 192.168.122.5 dev eth0
#sudo ip r a default  dev eth0
sudo /usr/sbin/sshd
}

function _s(){
#sudo ip a a 192.168.122.192 dev eth5
sudo dhcliet eth5
#sudo ip r a default  dev eth0
#sudo /usr/sbin/sshd
}

function st() {
  stty columns $1 rows $2
}

alias v=vim
alias vt=vtysh
alias sv="sudo vim"
alias st1="st 120 20"
alias st2="st 120 40"
alias st3="st 160 40"
alias st4="st 240 60"
alias ww="journalctl -b | grep -E 'zebra|static'"
alias www="journalctl -b --follow | grep -E 'zebra|static'"
alias qqq="journalctl -b | grep  QQQ"
alias wq="journalctl -b --follow | grep  QQQ"
alias cf="cat /var/log/vyatta/cfg-stdout.log"
alias def="sudo ip r a default  dev eth0"

_FRR=/usr/lib/frr/
export SYSTEMD_PAGER="cat " SYSTEMD_COLORS="1"

# sudo apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 871920D1991BC93C
# timedatectl set-timezone Europe/Kiev


function locate_bin {                            
  set -x  
  locate -b "\\$1" | xargs -ri find {} -prune -type f -executable
  set +x         
}   


alias set_resolv='sudo sh -c "echo nameserver 192.168.122.1 > /etc/resolv.conf"'
alias q="cd .."
alias r="ranger"

function clear_dump {
    sudo rm /var/log/vyatta/*
    sudo rm ~/perf*
}

function dump_collect {
    set -x
    mkdir $1 && pushd $1
    mkdir vyatta
    mv /var/log/vyatta/* vyatta/
    sudo mv ~/perf* .
    sudo sh -c 'perf script --header > perf.hist'
    sed -n /my_commit/,/^$/p perf.hist > my_commit.hist
    journalctl -b > journal.log
    cat journal.log | grep vyos-router > router.log
    set +x
}

ranger () 
{ 
    ( command ranger --choosedir=/tmp/x "$@" );
    cd $(command cat /tmp/x)
}

alias vtysh="sudo vtysh"
alias vts="sudo vtysh"
alias vr="vim /etc/frr/frr.conf"
#alias vr="sudo vi /usr/libexec/vyos/init/vyos-router"
alias vu="vtysh -f /etc/frr/frr.conf"
alias vub="vtysh -f /etc/frr/frr.conf_back"

clear_journal ()
{
    set -x;
    sudo journalctl --rotate;
    sudo journalctl --vacuum-time=1s
}

alias default="sudo ip route add default dev ens4"
alias pp1="ping -I 1.0.1.17 30.0.0.1 -c 3"
alias pp4="ping -I 1.0.1.17 30.0.0.4 -c 3"
alias pp5="ping -I 1.0.1.17 30.0.0.5 -c 3"
